import sqlite3


class Room:
    def __init__(self, name: str, id=None):
        self.name = name
        self.id = id

    def updateDB(self, db: sqlite3.Connection):
        # updates the db-entry if it exists else insert into the db
        cur = db.cursor()
        if self.id is None:  # Not inserted into table yet
            cur.execute("INSERT INTO room (name) VALUES (?)",
                        [self.name])
        else:
            cur.execute("UPDATE room SET name=? WHERE id=?",
                        [self.name, self.id])

        db.commit()

    def removeFromDB(self, db: sqlite3.Connection):
        cur = db.cursor()
        if self.id is None:
            print("Not in db")
        else:
            cur.execute("DELETE FROM room WHERE id=?", [self.id])
            db.commit()

    def __repr__(self):
        return f"(name={self.name}, id={self.id})"

def loadRaeume(db: sqlite3.Connection) -> list[Room]:
    cur = db.cursor()
    cur.execute("SELECT id, name FROM room")
    raeume = cur.fetchall()
    return list(map(lambda x: Room(x[1], x[0]), raeume))