import sqlite3


class Person:
    def __init__(self, name:str, id=None):
        self.name = name
        self.id = id

    def updateDB(self, db: sqlite3.Connection):
        # updates the db-entry if it exists else insert into the db
        cur = db.cursor()
        if self.id is None:  # Not inserted into table yet
            cur.execute("INSERT INTO person (name) VALUES (?)",
                        [self.name])
        else:
            cur.execute("UPDATE person SET name=? WHERE id=?",
                        [self.name, self.id])

        db.commit()

    def removeFromDB(self, db: sqlite3.Connection):
        cur = db.cursor()
        if self.id is None:
            print("Not in db")
        else:
            cur.execute("DELETE FROM person WHERE id=?", [self.id])
            db.commit()

    def __repr__(self):
        return f"(name={self.name}, id={self.id})"

def loadPersonen(db: sqlite3.Connection) -> list[Person]:
    cur = db.cursor()
    cur.execute("SELECT id, name FROM person")
    personen = cur.fetchall()
    return list(map(lambda x: Person(x[1], x[0]), personen))